/*
 * Decompiled with CFR 0.152.
 */
package ch.sic.ibantool;

import ch.sic.ibantool.MainBANInterface;
import ch.sic.ibantool.MainBCRecord;
import ch.sic.ibantool.MainBCStamm;
import ch.sic.ibantool.MainIBANRecord;
import ch.sic.ibantool.MainToolbox;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Bank_UBS
extends MainBANInterface {
    private MainToolbox tb = new MainToolbox();
    private HelpList Wert7;
    private HelpList Wert68;
    private HelpList PZWert;
    private MainBCStamm _bcs;

    Bank_UBS() {
        this.FillHelpLists();
    }

    void Init(MainBCStamm bcs) {
        this._bcs = bcs;
    }

    MainIBANRecord ComputeBAN(MainIBANRecord rec) throws Exception {
        StringBuffer PZ;
        boolean hasMatch = false;
        boolean needtofindbcinkoze = false;
        StringBuffer tmpKoze = new StringBuffer(rec.KoZE.toString());
        tmpKoze = this.tb.EliminateLeadingZero(tmpKoze);
        tmpKoze = this.tb.EliminateChar(' ', tmpKoze);
        StringBuffer Iban1 = new StringBuffer("^".concat("UBS").concat(".{0,35}$"));
        Pattern p_Iban = Pattern.compile(Iban1.toString());
        Matcher m_Iban = p_Iban.matcher(tmpKoze);
        if (m_Iban.matches()) {
            tmpKoze = new StringBuffer(tmpKoze.substring(3, tmpKoze.length()));
        }
        tmpKoze = this.tb.EliminateLeadingZero(tmpKoze);
        tmpKoze = this.tb.EliminateChar(' ', tmpKoze);
        Iban1 = new StringBuffer("^[A-Z]{2}[0-9]{7}[0-9A-Z]{8,16}$");
        p_Iban = Pattern.compile(Iban1.toString());
        m_Iban = p_Iban.matcher(this.tb.EliminateSpecialChar(tmpKoze));
        if (m_Iban.find()) {
            hasMatch = true;
            rec.VFlag = 21;
            rec.res2 = new StringBuffer("99");
        }
        if (!hasMatch && this._bcs != null && rec.Feld2Typ != 1 && rec.Feld2Typ != 5) {
            needtofindbcinkoze = true;
        }
        StringBuffer KontoSBG3 = new StringBuffer("\\d{6}[\\.|,|\\s]{0,1}[A-Z]{3}");
        StringBuffer KontoSBG2 = new StringBuffer("\\d{3}[\\.|\\s]{0,1}\\d{3}[\\.|,|\\s|-]{0,1}[A-Z]{1}\\d{1}\\s{0,1}[A-Z]{1}");
        StringBuffer KontoSBG1 = new StringBuffer("\\d{3}[\\.|,|\\s]{0,1}\\d{3}[\\.|,|\\s|-]{0,1}\\d{2}[\\.|\\s]{0,1}[A-Z]{1}");
        Matcher m_KontoSBG1 = null;
        Matcher m_KontoSBG2 = null;
        Matcher m_KontoSBG3 = null;
        if (!hasMatch) {
            Pattern p_KontoSBG1 = Pattern.compile(KontoSBG1.toString());
            m_KontoSBG1 = p_KontoSBG1.matcher(tmpKoze);
            Pattern p_KontoSBG2 = Pattern.compile(KontoSBG2.toString());
            m_KontoSBG2 = p_KontoSBG2.matcher(tmpKoze);
            Pattern p_KontoSBG3 = Pattern.compile(KontoSBG3.toString());
            m_KontoSBG3 = p_KontoSBG3.matcher(tmpKoze);
        }
        if (!hasMatch && m_KontoSBG3.find()) {
            hasMatch = true;
            rec = this.FindBCinKoZe(rec, tmpKoze, m_KontoSBG3.start(), m_KontoSBG3.end(), needtofindbcinkoze);
            if (rec.VFlag == -1) {
                tmpKoze = new StringBuffer(tmpKoze.substring(0, m_KontoSBG3.end()));
                tmpKoze = new StringBuffer(tmpKoze.substring(m_KontoSBG3.start(), tmpKoze.length()));
                if ((tmpKoze = this.tb.EliminateSpecialChar(tmpKoze)).length() == 9) {
                    PZ = new StringBuffer(tmpKoze.substring(8, 9));
                    if (PZ.toString().intern() == this.CalcPZ(tmpKoze).toString().intern()) {
                        rec.Ban = new StringBuffer(rec.IID_BC.toString().concat(tmpKoze.toString()));
                        rec.VFlag = 1;
                        rec.Feld3Typ = 3;
                        rec.KoZe_modifiziert = tmpKoze;
                    } else {
                        rec.VFlag = 22;
                        rec.Feld3Typ = 3;
                        rec.KoZe_modifiziert = tmpKoze;
                    }
                } else {
                    rec.VFlag = 20;
                }
            }
        }
        if (!hasMatch && m_KontoSBG2.find()) {
            hasMatch = true;
            rec = this.FindBCinKoZe(rec, tmpKoze, m_KontoSBG2.start(), m_KontoSBG2.end(), needtofindbcinkoze);
            if (rec.VFlag == -1) {
                tmpKoze = new StringBuffer(tmpKoze.substring(0, m_KontoSBG2.end()));
                tmpKoze = new StringBuffer(tmpKoze.substring(m_KontoSBG2.start(), tmpKoze.length()));
                if ((tmpKoze = this.tb.EliminateSpecialChar(tmpKoze)).length() == 9) {
                    PZ = new StringBuffer(tmpKoze.substring(8, 9));
                    if (PZ.toString().intern() == this.CalcPZ(tmpKoze).toString().intern()) {
                        rec.Ban = new StringBuffer(rec.IID_BC.toString().concat(tmpKoze.toString()));
                        rec.VFlag = 1;
                        rec.Feld3Typ = 2;
                        rec.KoZe_modifiziert = tmpKoze;
                    } else {
                        rec.VFlag = 22;
                        rec.Feld3Typ = 2;
                        rec.KoZe_modifiziert = tmpKoze;
                    }
                } else {
                    rec.VFlag = 20;
                }
            }
        }
        if (!hasMatch && m_KontoSBG1.find()) {
            hasMatch = true;
            rec = this.FindBCinKoZe(rec, tmpKoze, m_KontoSBG1.start(), m_KontoSBG1.end(), needtofindbcinkoze);
            if (rec.VFlag == -1) {
                tmpKoze = new StringBuffer(tmpKoze.substring(0, m_KontoSBG1.end()));
                tmpKoze = new StringBuffer(tmpKoze.substring(m_KontoSBG1.start(), tmpKoze.length()));
                if ((tmpKoze = this.tb.EliminateSpecialChar(tmpKoze)).length() == 9) {
                    PZ = new StringBuffer(tmpKoze.substring(8, 9));
                    if (PZ.toString().intern() == this.CalcPZ(tmpKoze).toString().intern()) {
                        rec.Ban = new StringBuffer(rec.IID_BC.toString().concat(tmpKoze.toString()));
                        rec.VFlag = 1;
                        rec.Feld3Typ = 1;
                        rec.KoZe_modifiziert = tmpKoze;
                    } else {
                        rec.VFlag = 22;
                        rec.Feld3Typ = 1;
                        rec.KoZe_modifiziert = tmpKoze;
                    }
                } else {
                    rec.VFlag = 20;
                }
            }
        }
        Matcher m_KontoSBV1 = null;
        Matcher m_KontoSBV11 = null;
        StringBuffer Konto_SBV1 = new StringBuffer("([A-Z]{1}[\\s|-]{0,1}[0-9]{1})[\\.|\\s|-]{0,1}\\d{3}[\\.|,|-]{0,1}\\d{3}([\\.|-]{0,1}\\d{1})");
        StringBuffer Konto_SBV11 = new StringBuffer("([A-Z]{2}|[A-Z]{1}[0]{1})[\\.|\\s|-]{0,1}\\d{3}[\\.|,|-]{0,1}\\d{3}[\\.|-]{0,1}\\d{1}");
        if (!hasMatch) {
            Pattern p_KontoSBV1 = Pattern.compile(Konto_SBV1.toString());
            m_KontoSBV1 = p_KontoSBV1.matcher(tmpKoze);
            Pattern p_KontoSBV11 = Pattern.compile(Konto_SBV11.toString());
            m_KontoSBV11 = p_KontoSBV11.matcher(tmpKoze);
        }
        if (!hasMatch && m_KontoSBV1.find()) {
            rec = this.FindBCinKoZe(rec, tmpKoze, m_KontoSBV1.start(), m_KontoSBV1.end(), needtofindbcinkoze);
            if (rec.VFlag == -1 && tmpKoze.substring(0, 2).intern() != "CH") {
                hasMatch = true;
                tmpKoze = new StringBuffer(tmpKoze.substring(0, m_KontoSBV1.end()));
                tmpKoze = new StringBuffer(tmpKoze.substring(m_KontoSBV1.start(), tmpKoze.length()));
                if ((tmpKoze = this.tb.EliminateSpecialChar(tmpKoze)).length() == 9) {
                    rec.Ban = new StringBuffer(rec.IID_BC.toString().concat(tmpKoze.toString()));
                    rec.VFlag = 2;
                    rec.Feld3Typ = 10;
                    rec.KoZe_modifiziert = tmpKoze;
                } else {
                    rec.VFlag = 20;
                    rec.Feld3Typ = 10;
                }
            }
        }
        if (!hasMatch && m_KontoSBV11.find()) {
            rec = this.FindBCinKoZe(rec, tmpKoze, m_KontoSBV11.start(), m_KontoSBV11.end(), needtofindbcinkoze);
            if (rec.VFlag == -1 && tmpKoze.substring(0, 2).intern() != "CH") {
                hasMatch = true;
                tmpKoze = new StringBuffer(tmpKoze.substring(0, m_KontoSBV11.end()));
                tmpKoze = new StringBuffer(tmpKoze.substring(m_KontoSBV11.start(), tmpKoze.length()));
                if ((tmpKoze = this.tb.EliminateSpecialChar(tmpKoze)).length() == 9) {
                    rec.Ban = new StringBuffer(rec.IID_BC.toString().concat(tmpKoze.toString()));
                    rec.VFlag = 2;
                    rec.Feld3Typ = 10;
                    rec.KoZe_modifiziert = tmpKoze;
                } else {
                    rec.VFlag = 20;
                    rec.Feld3Typ = 10;
                }
            }
        }
        Matcher m_KontoSBV2 = null;
        StringBuffer Konto_SBV2 = new StringBuffer("[0-9]{1}[\\s]{0,1}[A-Z]{1}[\\s|\\.|-]{0,1}[0-9]{3}[\\.]{0,1}[0-9]{3}[\\.|-]{0,1}[0-9]{1}");
        if (!hasMatch) {
            Pattern p_KontoSBV2 = Pattern.compile(Konto_SBV2.toString());
            m_KontoSBV2 = p_KontoSBV2.matcher(tmpKoze);
        }
        if (!hasMatch && m_KontoSBV2.find()) {
            rec = this.FindBCinKoZe(rec, tmpKoze, m_KontoSBV2.start(), m_KontoSBV2.end(), needtofindbcinkoze);
            if (rec.VFlag == -1) {
                hasMatch = true;
                tmpKoze = new StringBuffer(tmpKoze.substring(0, m_KontoSBV2.end()));
                tmpKoze = new StringBuffer(tmpKoze.substring(m_KontoSBV2.start(), tmpKoze.length()));
                if ((tmpKoze = this.tb.EliminateSpecialChar(tmpKoze)).length() == 9) {
                    rec.Ban = new StringBuffer(rec.IID_BC.toString().concat(tmpKoze.toString()));
                    rec.VFlag = 2;
                    rec.Feld3Typ = 11;
                    rec.KoZe_modifiziert = tmpKoze;
                } else {
                    rec.VFlag = 20;
                }
            }
        }
        if (!hasMatch) {
            if (rec.VFlag == -1) {
                rec = this.PatternFabric(rec, new StringBuffer("^[0-9]{8}(\\.|\\s|-){1}[0-9]{1}$"), 101, true, needtofindbcinkoze);
            }
            if (rec.VFlag == -1) {
                rec = this.PatternFabric(rec, new StringBuffer("^[0-9]{6}(\\.|\\s|-){1}[0-9]{3}$"), 103, true, needtofindbcinkoze);
            }
            if (rec.VFlag == -1) {
                rec = this.PatternFabric(rec, new StringBuffer("^[0-9]{9}$"), 107, true, needtofindbcinkoze);
            }
            if (rec.VFlag == -1) {
                rec = this.PatternFabric(rec, new StringBuffer("^[0-9]{2}(\\.|\\s|-){1}[0-9]{3},[0-9]{3}(\\.|\\s|-){1}[0-9]{1}$"), 117, false, needtofindbcinkoze);
            }
            if (rec.VFlag == -1) {
                rec = this.PatternFabric(rec, new StringBuffer("^[0-9]{2}(\\.|\\s|-){1}[0-9]{6}(\\.|\\s|-){1}[0-9]{1}$"), 118, false, needtofindbcinkoze);
            }
            if (rec.VFlag == -1) {
                rec = this.PatternFabric(rec, new StringBuffer("^[0-9]{2}(\\.|\\s|-){1}[0-9]{3}(\\.|\\s|-){1}[0-9]{3}(\\.|\\s|-){1}[0-9]{1}$"), 119, false, needtofindbcinkoze);
            }
            if (rec.VFlag == -1) {
                rec = this.PatternFabric(rec, new StringBuffer("^[0-9]{9}$"), 120, false, needtofindbcinkoze);
            }
            if (rec.VFlag == -1) {
                rec = this.PatternFabric(rec, new StringBuffer("^[0]{1}[0-9]{9}$"), 122, false, needtofindbcinkoze);
            }
            if (rec.VFlag == -1) {
                rec = this.PatternFabric(rec, new StringBuffer("^[0-9]{2}-[0-9]{7}$"), 125, false, needtofindbcinkoze);
            }
            if (rec.VFlag == -1) {
                rec = this.PatternFabric(rec, new StringBuffer("^[0-9]{8}(\\.|\\s|-){1}[0-9]{1}$"), 127, false, needtofindbcinkoze);
            }
            if (rec.Feld3Typ > 99 && rec.Feld3Typ < 132) {
                hasMatch = true;
            }
        }
        if (!hasMatch) {
            rec.VFlag = 20;
        }
        return rec;
    }

    private MainIBANRecord FindBCinKoZe(MainIBANRecord rec, StringBuffer tmpKoze, int start, int end, boolean required) throws Exception {
        MainBCRecord FI;
        StringBuffer evBC;
        MainToolbox tb = new MainToolbox();
        boolean hasBCinKoze = false;
        Pattern p_BC_vorne = Pattern.compile("[2]{1}[0-9]{2}");
        Matcher m_BC_vorne = null;
        if (start > 2) {
            StringBuffer bcvorne = new StringBuffer(tmpKoze.substring(0, start));
            m_BC_vorne = p_BC_vorne.matcher(bcvorne);
            int i = 0;
            while (m_BC_vorne.find(i)) {
                evBC = new StringBuffer(m_BC_vorne.group());
                FI = this._bcs.GetBCRecordbyBCNumber(Integer.parseInt(evBC.toString()));
                if (FI != null && FI.AlgorithmusKtoPropr != null && FI.AlgorithmusKtoPropr.intern() == "UBS" && FI.TeilnahmeIBAN) {
                    rec.bcrecord = FI;
                    rec.IID_BC = new StringBuffer(String.valueOf(FI.IID));
                    hasBCinKoze = true;
                }
                ++i;
            }
        }
        if (!hasBCinKoze) {
            Pattern p_BC_hinten = Pattern.compile("[0]{0,1}[2]{1}[0-9]{2}");
            Matcher m_BC_hinten = null;
            if (end < tmpKoze.length() - 2) {
                StringBuffer bchinten = new StringBuffer(tmpKoze.substring(end, tmpKoze.length()));
                m_BC_hinten = p_BC_hinten.matcher(bchinten);
                while (m_BC_hinten.find()) {
                    evBC = new StringBuffer(m_BC_hinten.group());
                    FI = this._bcs.GetBCRecordbyBCNumber(Integer.parseInt(evBC.toString()));
                    if (FI == null || FI.AlgorithmusKtoPropr == null || FI.AlgorithmusKtoPropr.intern() != "UBS" || !FI.TeilnahmeIBAN) continue;
                    rec.bcrecord = FI;
                    rec.IID_BC = new StringBuffer(String.valueOf(FI.IID));
                    hasBCinKoze = true;
                    break;
                }
            }
        }
        if (!hasBCinKoze && required) {
            rec.VFlag = 23;
        }
        return rec;
    }

    private StringBuffer CalcPZ(StringBuffer in) throws Exception {
        StringBuffer Result = new StringBuffer("");
        int modulo = 0;
        int total = 0;
        if (in.length() == 9 && this.tb.isNumber(new StringBuffer(in.substring(0, 5)))) {
            total += Integer.parseInt(in.substring(0, 1)) * 3;
            total += Integer.parseInt(in.substring(1, 2)) * 4;
            total += Integer.parseInt(in.substring(2, 3)) * 5;
            total += Integer.parseInt(in.substring(3, 4)) * 6;
            total += Integer.parseInt(in.substring(4, 5)) * 7;
            total += Integer.parseInt(this.Wert68.getElementbyName(new StringBuffer(in.substring(5, 6))).toString()) * 8;
            total += Integer.parseInt(this.Wert7.getElementbyName(new StringBuffer(in.substring(6, 7))).toString());
            modulo = 1 + (total += Integer.parseInt(this.Wert68.getElementbyName(new StringBuffer(in.substring(7, 8))).toString()) * 2) % 23;
            Result = this.PZWert.getElementbyName(new StringBuffer(String.valueOf(modulo)));
        } else {
            Result = new StringBuffer("");
        }
        return Result;
    }

    private void FillHelpLists() {
        this.Wert7 = new HelpList(23);
        this.Wert7.add(new ListElement(new StringBuffer("0"), new StringBuffer("1")));
        this.Wert7.add(new ListElement(new StringBuffer("1"), new StringBuffer("5")));
        this.Wert7.add(new ListElement(new StringBuffer("2"), new StringBuffer("6")));
        this.Wert7.add(new ListElement(new StringBuffer("3"), new StringBuffer("10")));
        this.Wert7.add(new ListElement(new StringBuffer("4"), new StringBuffer("19")));
        this.Wert7.add(new ListElement(new StringBuffer("5"), new StringBuffer("21")));
        this.Wert7.add(new ListElement(new StringBuffer("6"), new StringBuffer("7")));
        this.Wert7.add(new ListElement(new StringBuffer("7"), new StringBuffer("8")));
        this.Wert7.add(new ListElement(new StringBuffer("8"), new StringBuffer("17")));
        this.Wert7.add(new ListElement(new StringBuffer("9"), new StringBuffer("9")));
        this.Wert7.add(new ListElement(new StringBuffer("A"), new StringBuffer("4")));
        this.Wert7.add(new ListElement(new StringBuffer("B"), new StringBuffer("3")));
        this.Wert7.add(new ListElement(new StringBuffer("C"), new StringBuffer("9")));
        this.Wert7.add(new ListElement(new StringBuffer("D"), new StringBuffer("21")));
        this.Wert7.add(new ListElement(new StringBuffer("E"), new StringBuffer("11")));
        this.Wert7.add(new ListElement(new StringBuffer("F"), new StringBuffer("14")));
        this.Wert7.add(new ListElement(new StringBuffer("G"), new StringBuffer("6")));
        this.Wert7.add(new ListElement(new StringBuffer("H"), new StringBuffer("18")));
        this.Wert7.add(new ListElement(new StringBuffer("I"), new StringBuffer("20")));
        this.Wert7.add(new ListElement(new StringBuffer("J"), new StringBuffer("2")));
        this.Wert7.add(new ListElement(new StringBuffer("K"), new StringBuffer("6")));
        this.Wert7.add(new ListElement(new StringBuffer("L"), new StringBuffer("2")));
        this.Wert7.add(new ListElement(new StringBuffer("M"), new StringBuffer("22")));
        this.Wert68 = new HelpList(36);
        this.Wert68.add(new ListElement(new StringBuffer("0"), new StringBuffer("0")));
        this.Wert68.add(new ListElement(new StringBuffer("1"), new StringBuffer("1")));
        this.Wert68.add(new ListElement(new StringBuffer("2"), new StringBuffer("2")));
        this.Wert68.add(new ListElement(new StringBuffer("3"), new StringBuffer("3")));
        this.Wert68.add(new ListElement(new StringBuffer("4"), new StringBuffer("4")));
        this.Wert68.add(new ListElement(new StringBuffer("5"), new StringBuffer("5")));
        this.Wert68.add(new ListElement(new StringBuffer("6"), new StringBuffer("6")));
        this.Wert68.add(new ListElement(new StringBuffer("7"), new StringBuffer("7")));
        this.Wert68.add(new ListElement(new StringBuffer("8"), new StringBuffer("8")));
        this.Wert68.add(new ListElement(new StringBuffer("9"), new StringBuffer("9")));
        this.Wert68.add(new ListElement(new StringBuffer("A"), new StringBuffer("6")));
        this.Wert68.add(new ListElement(new StringBuffer("B"), new StringBuffer("7")));
        this.Wert68.add(new ListElement(new StringBuffer("C"), new StringBuffer("8")));
        this.Wert68.add(new ListElement(new StringBuffer("D"), new StringBuffer("9")));
        this.Wert68.add(new ListElement(new StringBuffer("E"), new StringBuffer("10")));
        this.Wert68.add(new ListElement(new StringBuffer("F"), new StringBuffer("11")));
        this.Wert68.add(new ListElement(new StringBuffer("G"), new StringBuffer("12")));
        this.Wert68.add(new ListElement(new StringBuffer("H"), new StringBuffer("13")));
        this.Wert68.add(new ListElement(new StringBuffer("I"), new StringBuffer("14")));
        this.Wert68.add(new ListElement(new StringBuffer("J"), new StringBuffer("15")));
        this.Wert68.add(new ListElement(new StringBuffer("K"), new StringBuffer("0")));
        this.Wert68.add(new ListElement(new StringBuffer("L"), new StringBuffer("1")));
        this.Wert68.add(new ListElement(new StringBuffer("M"), new StringBuffer("2")));
        this.Wert68.add(new ListElement(new StringBuffer("N"), new StringBuffer("3")));
        this.Wert68.add(new ListElement(new StringBuffer("O"), new StringBuffer("4")));
        this.Wert68.add(new ListElement(new StringBuffer("P"), new StringBuffer("5")));
        this.Wert68.add(new ListElement(new StringBuffer("Q"), new StringBuffer("6")));
        this.Wert68.add(new ListElement(new StringBuffer("R"), new StringBuffer("7")));
        this.Wert68.add(new ListElement(new StringBuffer("S"), new StringBuffer("8")));
        this.Wert68.add(new ListElement(new StringBuffer("T"), new StringBuffer("9")));
        this.Wert68.add(new ListElement(new StringBuffer("U"), new StringBuffer("10")));
        this.Wert68.add(new ListElement(new StringBuffer("V"), new StringBuffer("11")));
        this.Wert68.add(new ListElement(new StringBuffer("W"), new StringBuffer("12")));
        this.Wert68.add(new ListElement(new StringBuffer("X"), new StringBuffer("13")));
        this.Wert68.add(new ListElement(new StringBuffer("Y"), new StringBuffer("14")));
        this.Wert68.add(new ListElement(new StringBuffer("Z"), new StringBuffer("15")));
        this.PZWert = new HelpList(23);
        this.PZWert.add(new ListElement(new StringBuffer("1"), new StringBuffer("U")));
        this.PZWert.add(new ListElement(new StringBuffer("2"), new StringBuffer("B")));
        this.PZWert.add(new ListElement(new StringBuffer("3"), new StringBuffer("A")));
        this.PZWert.add(new ListElement(new StringBuffer("4"), new StringBuffer("E")));
        this.PZWert.add(new ListElement(new StringBuffer("5"), new StringBuffer("V")));
        this.PZWert.add(new ListElement(new StringBuffer("6"), new StringBuffer("M")));
        this.PZWert.add(new ListElement(new StringBuffer("7"), new StringBuffer("N")));
        this.PZWert.add(new ListElement(new StringBuffer("8"), new StringBuffer("C")));
        this.PZWert.add(new ListElement(new StringBuffer("9"), new StringBuffer("X")));
        this.PZWert.add(new ListElement(new StringBuffer("10"), new StringBuffer("L")));
        this.PZWert.add(new ListElement(new StringBuffer("11"), new StringBuffer("D")));
        this.PZWert.add(new ListElement(new StringBuffer("12"), new StringBuffer("R")));
        this.PZWert.add(new ListElement(new StringBuffer("13"), new StringBuffer("F")));
        this.PZWert.add(new ListElement(new StringBuffer("14"), new StringBuffer("H")));
        this.PZWert.add(new ListElement(new StringBuffer("15"), new StringBuffer("T")));
        this.PZWert.add(new ListElement(new StringBuffer("16"), new StringBuffer("G")));
        this.PZWert.add(new ListElement(new StringBuffer("17"), new StringBuffer("Z")));
        this.PZWert.add(new ListElement(new StringBuffer("18"), new StringBuffer("P")));
        this.PZWert.add(new ListElement(new StringBuffer("19"), new StringBuffer("W")));
        this.PZWert.add(new ListElement(new StringBuffer("20"), new StringBuffer("K")));
        this.PZWert.add(new ListElement(new StringBuffer("21"), new StringBuffer("Q")));
        this.PZWert.add(new ListElement(new StringBuffer("22"), new StringBuffer("J")));
        this.PZWert.add(new ListElement(new StringBuffer("23"), new StringBuffer("Y")));
    }

    private MainIBANRecord PatternFabric(MainIBANRecord rec, StringBuffer KontoSpec1, int feld3typ, boolean replacebc, boolean needtofindbc) throws Exception {
        StringBuffer tmpKoze = new StringBuffer(rec.KoZE.toString());
        StringBuffer tmp_IID_BC = null;
        Object tmp_IID_PC = null;
        MainBCRecord FI = null;
        boolean hasMatch = false;
        if (replacebc || needtofindbc) {
            Pattern p_temp = Pattern.compile("^[2]{1}[0-9]{2}[\\.|-|\\s]{0,1}");
            Matcher m_temp = p_temp.matcher(tmpKoze);
            if (m_temp.find()) {
                tmpKoze = new StringBuffer(tmpKoze.toString().substring(m_temp.end(), tmpKoze.length()));
                tmpKoze = this.tb.EliminateLeadingSC(tmpKoze);
                StringBuffer origbc = new StringBuffer(m_temp.group().substring(0, 3));
                FI = this._bcs.GetBCRecordbyBCNumber(Integer.parseInt(origbc.toString()));
                if (FI != null && FI.AlgorithmusKtoPropr != null && FI.AlgorithmusKtoPropr.intern() == "UBS" && FI.TeilnahmeIBAN) {
                    tmp_IID_BC = new StringBuffer(String.valueOf(FI.IID));
                    hasMatch = true;
                } else if (needtofindbc) {
                    rec.VFlag = 23;
                }
            }
        } else {
            hasMatch = true;
        }
        Matcher m_KontoSpec1 = null;
        Pattern p_KontoSpec1 = Pattern.compile(KontoSpec1.toString());
        m_KontoSpec1 = p_KontoSpec1.matcher(tmpKoze);
        if (hasMatch && m_KontoSpec1.find()) {
            if (FI != null) {
                rec.bcrecord = FI;
                if (tmp_IID_BC != null) {
                    rec.IID_BC = new StringBuffer(String.valueOf(FI.IID));
                }
                if (tmp_IID_BC != null) {
                    // empty if block
                }
            }
            tmpKoze = new StringBuffer(tmpKoze.substring(0, m_KontoSpec1.end()));
            tmpKoze = new StringBuffer(tmpKoze.substring(m_KontoSpec1.start(), tmpKoze.length()));
            tmpKoze = this.tb.EliminateSpecialChar(tmpKoze);
            rec.Ban = new StringBuffer(String.valueOf(rec.bcrecord.IID).concat(this.tb.EliminateSpecialChar(tmpKoze).toString()));
            rec.VFlag = 2;
            rec.Feld3Typ = feld3typ;
            rec.KoZe_modifiziert = tmpKoze;
        }
        return rec;
    }

    class ListElement {
        StringBuffer Value1;
        StringBuffer Value2;

        ListElement(StringBuffer v1, StringBuffer v2) {
            this.Value1 = v1;
            this.Value2 = v2;
        }
    }

    class HelpList {
        private ListElement[] theList;
        private int nextElement = 0;
        private int maxElements;

        HelpList(int Size) {
            this.maxElements = Size;
            this.theList = new ListElement[Size];
        }

        void add(ListElement e) {
            if (this.nextElement <= this.maxElements) {
                this.theList[this.nextElement] = e;
                ++this.nextElement;
            }
        }

        StringBuffer getElementbyName(StringBuffer search) throws Exception {
            StringBuffer Result = new StringBuffer("0");
            for (int i = 0; i < this.nextElement; ++i) {
                if (this.theList[i].Value1.toString().intern() != search.toString().intern()) continue;
                Result = this.theList[i].Value2;
                break;
            }
            return Result;
        }
    }
}

