/*
 * Decompiled with CFR 0.152.
 */
package ch.sic.ibantool;

import ch.sic.ibantool.MainBCLookup;
import ch.sic.ibantool.MainBCStamm;
import ch.sic.ibantool.MainEinzelabfrageGUI;
import ch.sic.ibantool.MainIBANRecord;
import ch.sic.ibantool.MainInit;
import ch.sic.ibantool.MainReader;
import ch.sic.ibantool.MainReaderASCII;
import ch.sic.ibantool.MainReaderXML;
import ch.sic.ibantool.MainStatistics;
import ch.sic.ibantool.MainWriter;
import ch.sic.ibantool.MainWriterASCII;
import ch.sic.ibantool.MainWriterXML;
import ch.sic.ibantool.RecordIban;
import java.io.FileNotFoundException;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class Main {
    private static StringBuffer Inputfile = new StringBuffer("");
    private static StringBuffer Outputfile = new StringBuffer("");
    private static boolean XMLFiles = false;
    private static boolean ASCIIFiles = false;
    private static boolean Erweitert = false;
    private static boolean GUIOn = false;
    private static boolean CheckVersion = false;
    private static StringBuffer Lang = new StringBuffer("D");
    private static StringBuffer ExpiryDate = new StringBuffer("31.07.2026");
    private static StringBuffer Version = new StringBuffer("48.2.1");
    private static boolean hasFiles = false;
    private static boolean GUIEinzelabfrage = false;
    private static boolean GUIStats = false;
    private static boolean ParameterOK = false;
    private MainBCStamm ext_bcstamm;
    private MainBCLookup ext_bclookup;
    private MainInit ext_banlookup;

    public static void main(String[] args) {
        block14: {
            try {
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTimeZone(TimeZone.getTimeZone("CET"));
                boolean expired = (cal.get(2) + 1 > 7 || cal.get(1) > 2026) && cal.get(1) > 2025;
                Main.CheckParameters(args);
                if (ParameterOK && GUIEinzelabfrage) {
                    MainEinzelabfrageGUI mainEinzelabfrageGUI = new MainEinzelabfrageGUI(Lang, Erweitert, expired, ExpiryDate);
                }
                if (ParameterOK && hasFiles) {
                    MainBCStamm bcstamm = new MainBCStamm("bcstamm.csv");
                    MainBCLookup bc1ookup = new MainBCLookup(bcstamm);
                    MainInit banlookup = new MainInit(bcstamm);
                    MainReader reader = new MainReaderASCII();
                    MainWriter writer = new MainWriterASCII();
                    if (XMLFiles) {
                        reader = new MainReaderXML();
                        writer = new MainWriterXML();
                    }
                    reader.open(Inputfile.toString());
                    MainStatistics stats = new MainStatistics(GUIStats, reader.Listsize(), Inputfile, Outputfile, expired, ExpiryDate);
                    if (!expired) {
                        writer.SetExtended(Erweitert);
                        writer.open(Outputfile.toString());
                        for (int ii = 0; ii < reader.Listsize(); ++ii) {
                            MainIBANRecord tmprec = reader.NextRecord();
                            if (tmprec.VFlag == 0) continue;
                            try {
                                tmprec = bc1ookup.ComputeBC(tmprec);
                                tmprec = banlookup.ComputeBAN(tmprec);
                                tmprec.ComputeIban();
                            }
                            catch (Exception e) {
                                if (Erweitert) {
                                    e.printStackTrace();
                                }
                                tmprec.VFlag = 20;
                            }
                            stats.Add(tmprec);
                            writer.AddRecord(tmprec);
                        }
                        if (reader.Listsize() > 1) {
                            writer.AddTotalRecord(stats.ComputeTotalRecord());
                        }
                        writer.close();
                        if (Erweitert) {
                            System.out.println("Records: " + reader.Listsize());
                        }
                    }
                    reader.close();
                    reader = null;
                    writer = null;
                }
                if (!ParameterOK) {
                    System.out.println("Wrong Parameters");
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                if (!Erweitert) break block14;
                e.printStackTrace();
            }
        }
    }

    private static void CheckParameters(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-v")) {
                CheckVersion = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-e")) {
                Erweitert = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-g")) {
                GUIOn = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-l") && args.length > i + 1) {
                if (String.valueOf(args[i + 1]).equalsIgnoreCase("D")) {
                    Lang = new StringBuffer("D");
                } else if (String.valueOf(args[i + 1]).equalsIgnoreCase("E")) {
                    Lang = new StringBuffer("E");
                } else if (String.valueOf(args[i + 1]).equalsIgnoreCase("F")) {
                    Lang = new StringBuffer("F");
                } else if (String.valueOf(args[i + 1]).equalsIgnoreCase("I")) {
                    Lang = new StringBuffer("I");
                }
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-i") && args.length > i + 1) {
                Inputfile = new StringBuffer(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-o") && args.length > i + 1) {
                Outputfile = new StringBuffer(args[i + 1]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-a")) {
                ASCIIFiles = true;
                continue;
            }
            if (!args[i].equalsIgnoreCase("-x")) continue;
            XMLFiles = true;
        }
        if (!ASCIIFiles && !XMLFiles && GUIOn && Outputfile.length() == 0 && Inputfile.length() == 0) {
            GUIEinzelabfrage = true;
            ParameterOK = true;
        }
        if (ASCIIFiles | XMLFiles && !ASCIIFiles | !XMLFiles && Inputfile.length() > 2 && Outputfile.length() > 2) {
            hasFiles = true;
            if (GUIOn) {
                GUIStats = true;
            }
            ParameterOK = true;
        }
        if (CheckVersion && !ASCIIFiles && !XMLFiles && !GUIOn && Outputfile.length() == 0 && Inputfile.length() == 0) {
            ParameterOK = true;
            System.out.println("Version:" + Version.toString() + " - Date of expiration:" + ExpiryDate.toString());
        }
    }

    public RecordIban IBANConvert(RecordIban ibanrec) {
        return this.IBANConvert(new StringBuffer(ibanrec.IndKuRef.toString()), new StringBuffer(ibanrec.BCPC.toString()), new StringBuffer(ibanrec.KoZe.toString().toUpperCase().trim()));
    }

    public RecordIban IBANConvert(StringBuffer BCPC, StringBuffer KoZe) {
        return this.IBANConvert(new StringBuffer(""), BCPC, KoZe);
    }

    public RecordIban IBANConvert(StringBuffer IndKuRef, StringBuffer BCPC, StringBuffer KoZe) {
        RecordIban Result;
        block15: {
            Result = new RecordIban();
            Result.IndKuRef = IndKuRef;
            Result.BCPC = BCPC;
            Result.KoZe = KoZe;
            KoZe = new StringBuffer(KoZe.toString().toUpperCase().trim());
            if (IndKuRef == null) {
                IndKuRef = new StringBuffer("");
            }
            if (BCPC == null) {
                BCPC = new StringBuffer("");
            }
            if (KoZe == null) {
                KoZe = new StringBuffer("");
            }
            if (Result.IndKuRef.length() < 36 && Result.BCPC.length() < 12) {
                if (Result.KoZe.length() < 35) {
                    try {
                        if (this.ext_bcstamm == null) {
                            this.ext_bcstamm = new MainBCStamm("bcstamm.csv");
                        }
                        if (this.ext_bclookup == null) {
                            this.ext_bclookup = new MainBCLookup(this.ext_bcstamm);
                        }
                        if (this.ext_banlookup == null) {
                            this.ext_banlookup = new MainInit(this.ext_bcstamm);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        GregorianCalendar cal = new GregorianCalendar();
                        cal.setTimeZone(TimeZone.getTimeZone("CET"));
                        if (cal.get(2) + 1 <= 7 && cal.get(1) <= 2026 || cal.get(1) <= 2025) {
                            MainIBANRecord tmprec = new MainIBANRecord();
                            tmprec.InBC = BCPC;
                            tmprec.KoZE = KoZe;
                            tmprec = this.ext_bclookup.ComputeBC(tmprec);
                            tmprec = this.ext_banlookup.ComputeBAN(tmprec);
                            tmprec.ComputeIban();
                            Result.BCZeFi = tmprec.IID_BC;
                            Result.PCZeFi = tmprec.IID_PC;
                            Result.VFlag = new StringBuffer(String.valueOf(tmprec.VFlag));
                            Result.Iban = tmprec.Iban;
                            break block15;
                        }
                        Result.VFlag = new StringBuffer("31");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    Result.VFlag = new StringBuffer("29");
                }
            } else {
                Result.VFlag = new StringBuffer("29");
            }
        }
        return Result;
    }
}

