/*
 * Decompiled with CFR 0.152.
 */
package ch.sic.ibantool;

import ch.sic.ibantool.MainBCRecord;
import ch.sic.ibantool.MainBCStamm;
import ch.sic.ibantool.MainIBANRecord;
import ch.sic.ibantool.MainToolbox;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class MainBCLookup {
    private MainToolbox tb;
    private Pattern BCNr;
    private Pattern PCNr;
    private Pattern PCNrTyp2;
    private Pattern ESNr;
    private Pattern Swift;
    private MainBCStamm bcstamm;

    MainBCLookup(MainBCStamm bcsin) throws Exception {
        this.bcstamm = bcsin;
        this.tb = new MainToolbox();
        this.BCNr = Pattern.compile("^[0-9]{3,6}$");
        this.PCNr = Pattern.compile("^\\d{2}-\\d{1,6}-\\d{1}$|^[1-9]{1}[0-9]{8}$|^90[0-9]{7}$");
        this.PCNrTyp2 = Pattern.compile("^\\d{2}-\\d{1,6}-\\d{1}$");
        this.ESNr = Pattern.compile("^07[0-9]{7}$");
        this.Swift = Pattern.compile("^[a-zA-Z0-9]{8}$|^[a-zA-Z0-9]{11}$");
    }

    MainIBANRecord ComputeBC(MainIBANRecord iban_in) throws Exception {
        if (iban_in.VFlag != 0) {
            int ErrorCode = -1;
            boolean verarbeitet = false;
            iban_in.InBC = this.tb.EliminateChar(' ', iban_in.InBC);
            Matcher m_BC = this.BCNr.matcher(iban_in.InBC);
            Matcher m_PC = this.PCNr.matcher(iban_in.InBC);
            Matcher m_PCTyp2 = this.PCNrTyp2.matcher(iban_in.InBC);
            Matcher m_ES = this.ESNr.matcher(iban_in.InBC);
            Matcher m_Swift = this.Swift.matcher(iban_in.InBC);
            if (m_BC.matches()) {
                boolean islong = false;
                StringBuffer orig_bc = new StringBuffer(iban_in.InBC.toString());
                if (iban_in.InBC.length() == 6) {
                    islong = true;
                    iban_in.InBC = new StringBuffer(iban_in.InBC.substring(0, 5));
                }
                iban_in.InBC = this.tb.EliminateLeadingZero(iban_in.InBC);
                MainBCRecord tmp_BCRecord = this.bcstamm.GetBCRecordbyBCNumber(Integer.parseInt(iban_in.InBC.toString()));
                if (tmp_BCRecord.SortierNr != -1) {
                    if (tmp_BCRecord.TeilnahmeIBAN) {
                        iban_in.IID_BC = new StringBuffer(String.valueOf(tmp_BCRecord.IID));
                        iban_in.Feld2Typ = tmp_BCRecord.BCNummer == 9000 ? 6 : 1;
                        iban_in.bcrecord = tmp_BCRecord;
                    } else {
                        ErrorCode = 11;
                    }
                } else {
                    ErrorCode = 12;
                }
                if (islong) {
                    iban_in.InBC = orig_bc;
                }
                verarbeitet = true;
            }
            if (!verarbeitet && m_PC.matches()) {
                StringBuffer orig_PC = new StringBuffer(iban_in.InBC.toString());
                int tmp_Feld2Typ = 2;
                if (m_PCTyp2.matches()) {
                    iban_in.InBC = this.tb.EliminateChar('-', iban_in.InBC);
                    iban_in.InBC = this.PC_NormalizeTyp2(iban_in.InBC);
                    tmp_Feld2Typ = 3;
                }
                if (this.tb.CalcPZ_Mod10(iban_in.InBC)) {
                    iban_in.InBC.insert(2, "-");
                    iban_in.InBC.insert(9, "-");
                    while (iban_in.InBC.charAt(3) == '0') {
                        iban_in.InBC.deleteCharAt(3);
                    }
                    iban_in.Feld2Typ = 10;
                    verarbeitet = true;
                } else {
                    iban_in.InBC = orig_PC;
                    ErrorCode = 13;
                    verarbeitet = true;
                }
            }
            if (!verarbeitet && m_ES.matches()) {
                StringBuffer orig_BC = new StringBuffer(iban_in.InBC.toString());
                if (this.tb.CalcPZ_Mod10(iban_in.InBC)) {
                    iban_in.InBC.delete(7, 9);
                    iban_in.InBC.delete(0, 2);
                    while (iban_in.InBC.charAt(0) == '0') {
                        iban_in.InBC.deleteCharAt(0);
                    }
                    iban_in = this.ComputeBC(iban_in);
                    iban_in.InBC = orig_BC;
                } else {
                    ErrorCode = 13;
                }
                iban_in.Feld2Typ = 4;
                verarbeitet = true;
            }
            if (!verarbeitet && m_Swift.matches()) {
                StringBuffer orig_BC = new StringBuffer(iban_in.InBC.toString());
                MainBCRecord tmp_BCRecord = this.bcstamm.GetBCRecordbySwift(iban_in.InBC.toString().toUpperCase());
                if (tmp_BCRecord.SortierNr != -1) {
                    if (tmp_BCRecord.TeilnahmeIBAN) {
                        iban_in.InBC = new StringBuffer(String.valueOf(tmp_BCRecord.BCNummer));
                        iban_in = this.ComputeBC(iban_in);
                        iban_in.InBC = orig_BC;
                    } else {
                        ErrorCode = 11;
                    }
                } else {
                    ErrorCode = 12;
                }
                iban_in.Feld2Typ = iban_in.Feld2Typ == 6 ? 7 : 5;
                verarbeitet = true;
            }
            if (!verarbeitet) {
                if (iban_in.InBC.length() == 0) {
                    iban_in.Feld2Typ = 0;
                    ErrorCode = -1;
                } else {
                    iban_in.Feld2Typ = -1;
                    ErrorCode = 10;
                }
            }
            if (iban_in.VFlag == -1) {
                iban_in.VFlag = ErrorCode;
            }
        }
        if (iban_in.Feld3Typ != 99 && iban_in.Feld2Typ == 0 || iban_in.Feld2Typ >= 6 && iban_in.Feld2Typ <= 10) {
            iban_in.bcrecord = this.bcstamm.GetBCRecordbyBCNumber(9000);
            iban_in.IID_BC = new StringBuffer(String.valueOf(iban_in.bcrecord.IID));
            MainIBANRecord PF_rec = new MainIBANRecord();
            PF_rec.InBC = new StringBuffer(iban_in.KoZE.toString());
            PF_rec.Feld3Typ = 99;
            this.ComputeBC(PF_rec);
            iban_in.Feld3Typ = PF_rec.Feld2Typ;
            Object var2_3 = null;
        }
        return iban_in;
    }

    private StringBuffer PC_NormalizeTyp2(StringBuffer inpc) {
        StringBuffer Result = new StringBuffer();
        Result = inpc;
        while (Result.length() < 9) {
            Result.insert(2, "0");
        }
        return Result;
    }
}

