/*
 * Decompiled with CFR 0.152.
 */
package ch.sic.ibantool;

import ch.sic.ibantool.MainBCRecord;
import ch.sic.ibantool.MainToolbox;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

class MainBCStamm {
    private MainBCRecord[] listBCNummer;
    private int NumRecords;
    private ArrayList listBCNummerCache;
    private StringBuffer stringRead;

    MainBCStamm(String FileName) throws Exception {
        this.ImportData(FileName);
        this.listBCNummerCache = new ArrayList(25);
    }

    private void addtoCache(MainBCRecord BcToCache) {
        if (this.listBCNummerCache.size() > 24) {
            this.listBCNummerCache.remove(0);
        }
        this.listBCNummerCache.add(BcToCache);
    }

    MainBCRecord GetBCRecordbyBCNumber(int BCNummer) throws Exception {
        int i;
        MainBCRecord Result = new MainBCRecord();
        boolean foundinchache = false;
        for (i = this.listBCNummerCache.size() - 1; i >= 0; --i) {
            if (((MainBCRecord)this.listBCNummerCache.toArray()[i]).BCNummer != BCNummer) continue;
            Result = (MainBCRecord)this.listBCNummerCache.toArray()[i];
            if (this.listBCNummerCache.size() - i > 10) {
                this.addtoCache(Result);
            }
            foundinchache = true;
            if (Result.BCNummerNeu == 0 || !Result.TeilnahmeIBAN) break;
            Result = this.GetBCRecordbyBCNumber(Result.BCNummerNeu);
            break;
        }
        if (!foundinchache) {
            for (i = 0; i < this.NumRecords; ++i) {
                if (this.listBCNummer[i].BCNummer != BCNummer) continue;
                Result = this.listBCNummer[i];
                this.addtoCache(Result);
                if (Result.BCNummerNeu == 0 || !Result.TeilnahmeIBAN) break;
                Result = this.GetBCRecordbyBCNumber(Result.BCNummerNeu);
                break;
            }
        }
        return Result;
    }

    MainBCRecord GetBCRecordbySwift(String Swift) throws Exception {
        MainToolbox tb = new MainToolbox();
        MainBCRecord Result = new MainBCRecord();
        for (int i = 0; i < this.NumRecords; ++i) {
            if (Swift.length() == 11) {
                StringBuffer killNumbers;
                if (this.listBCNummer[i].SwiftBIC.equals(Swift)) {
                    Result = this.listBCNummer[i];
                    break;
                }
                if (!tb.isNumber(new StringBuffer(Swift.substring(8, 11))) || !this.listBCNummer[i].SwiftBIC.equals((killNumbers = new StringBuffer(Swift.substring(0, 8).concat("XXX"))).toString())) continue;
                Result = this.listBCNummer[i];
                continue;
            }
            if (Swift.length() != 8 || this.listBCNummer[i].SwiftBIC.length() <= 7 || !this.listBCNummer[i].SwiftBIC.subSequence(0, 8).equals(Swift)) continue;
            Result = this.listBCNummer[i];
            break;
        }
        return Result;
    }

    private void ImportData(String FileName) throws Exception {
        Cipher dcipher = null;
        SecretKey key = null;
        String passphrase = "ReadnextIntToken NullPointerException";
        byte[] salt = new byte[]{16, 18, 28, -100, 9, 74, 61, 90};
        int iterationCount = 25;
        PBEKeySpec keySpec = new PBEKeySpec(passphrase.toCharArray(), salt, iterationCount);
        try {
            key = SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(keySpec);
        }
        catch (NoSuchAlgorithmException ex) {
            ex.printStackTrace();
        }
        catch (InvalidKeySpecException ex) {
            ex.printStackTrace();
        }
        try {
            dcipher = Cipher.getInstance("PBEWithMD5AndDES");
            PBEParameterSpec paramSpec = new PBEParameterSpec(salt, iterationCount);
            dcipher.init(2, (Key)key, paramSpec);
        }
        catch (InvalidAlgorithmParameterException paramSpec) {
        }
        catch (NoSuchPaddingException paramSpec) {
        }
        catch (NoSuchAlgorithmException paramSpec) {
        }
        catch (InvalidKeyException paramSpec) {
            // empty catch block
        }
        int LineCounter = 1;
        InputStream frcount = this.getResourceStream("ch.sic.ibantool", FileName);
        CipherInputStream frcount2 = new CipherInputStream(frcount, dcipher);
        BufferedReader brcount = new BufferedReader(new InputStreamReader(frcount2));
        StringBuffer sb = new StringBuffer(brcount.readLine());
        String aLine = null;
        while ((aLine = brcount.readLine()) != null) {
            ++LineCounter;
        }
        this.listBCNummer = new MainBCRecord[LineCounter];
        InputStream fr = this.getResourceStream("ch.sic.ibantool", FileName);
        CipherInputStream fr2 = new CipherInputStream(fr, dcipher);
        BufferedReader br = new BufferedReader(new InputStreamReader(fr2));
        this.stringRead = new StringBuffer(br.readLine());
        int count = 0;
        while (!this.stringRead.toString().equals("EOF")) {
            try {
                MainBCRecord bcrTemp = new MainBCRecord();
                bcrTemp.SortierNr = Integer.parseInt(this.ReadnextStringToken());
                bcrTemp.BCNummer = Integer.parseInt(this.ReadnextStringToken());
                bcrTemp.BCNummerNeu = this.ReadnextIntToken();
                bcrTemp.TeilnahmeIBAN = this.ReadnextBooleanToken();
                bcrTemp.PZValidierung = this.ReadnextBooleanToken();
                bcrTemp.StrukturKtoProp = this.ReadnextBooleanToken();
                bcrTemp.AlgorithmusESCod = this.ReadnextIntToken();
                bcrTemp.AlgorithmusKtoPropr = this.ReadnextStringToken();
                bcrTemp.KtoNrMin = this.ReadnextIntToken();
                bcrTemp.KtoNrMax = this.ReadnextIntToken();
                bcrTemp.IID = this.ReadnextIntToken();
                bcrTemp.Landcode = this.ReadnextStringToken();
                String Postkonto_In = this.ReadnextStringToken();
                String Postkonto_Out = this.ReadnextStringToken();
                bcrTemp.SwiftBIC = this.ReadnextStringToken();
                bcrTemp.Email = this.ReadnextStringToken();
                bcrTemp.Mutationsdatum = this.ReadnextStringToken();
                this.listBCNummer[count] = bcrTemp;
            }
            catch (NumberFormatException nfe) {
                --count;
            }
            ++count;
            try {
                this.stringRead = new StringBuffer(br.readLine());
            }
            catch (NullPointerException e) {
                this.stringRead = new StringBuffer("EOF");
            }
        }
        this.NumRecords = count;
        br.close();
    }

    private InputStream getResourceStream(String pkgname, String fname) throws Exception {
        String resname = "/" + pkgname.replace('.', '/') + "/" + fname;
        Class<?> clazz = this.getClass();
        InputStream is = clazz.getResourceAsStream(resname);
        return is;
    }

    private String ReadnextStringToken() throws Exception {
        StringBuffer Result = new StringBuffer("");
        while (this.stringRead.length() > 0 && this.stringRead.charAt(0) != ';') {
            Result.append(this.stringRead.charAt(0));
            this.stringRead.deleteCharAt(0);
        }
        if (this.stringRead.length() > 0) {
            this.stringRead.deleteCharAt(0);
        }
        return Result.toString().trim();
    }

    private int ReadnextIntToken() throws Exception {
        int Result = 0;
        StringBuffer tmp_result = new StringBuffer(this.ReadnextStringToken());
        if (tmp_result.length() > 0) {
            try {
                Result = Integer.parseInt(tmp_result.toString());
            }
            catch (NumberFormatException nfe) {
                Result = 0;
            }
        } else {
            Result = 0;
        }
        return Result;
    }

    private boolean ReadnextBooleanToken() throws Exception {
        boolean Result = false;
        String tmp_Result = this.ReadnextStringToken().toString();
        Result = tmp_Result.equals("1");
        return Result;
    }
}

