/*
 * Decompiled with CFR 0.152.
 */
package ch.sic.ibantool;

import ch.sic.ibantool.MainBCRecord;
import ch.sic.ibantool.MainToolbox;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class MainIBANRecord {
    StringBuffer SeqNr = new StringBuffer("");
    StringBuffer IndKuRef = new StringBuffer("");
    StringBuffer InBC = new StringBuffer("");
    StringBuffer KoZE = new StringBuffer("");
    StringBuffer IID_BC;
    StringBuffer IID_PC;
    StringBuffer Iban;
    StringBuffer res1;
    StringBuffer res2;
    StringBuffer res3;
    StringBuffer secpositiv;
    StringBuffer secnegativ;
    StringBuffer KoZe_modifiziert = new StringBuffer("");
    StringBuffer Ban;
    int VFlag = -1;
    int SeqNrInt;
    int Feld2Typ = -1;
    int Feld3Typ = -1;
    MainBCRecord bcrecord;
    MainToolbox tb;

    MainIBANRecord() {
        this.IID_BC = new StringBuffer("");
        this.IID_PC = new StringBuffer("");
        this.Iban = new StringBuffer("");
        this.res1 = new StringBuffer("");
        this.res2 = new StringBuffer("");
        this.res3 = new StringBuffer("");
        this.Ban = new StringBuffer("");
        this.bcrecord = new MainBCRecord();
        this.secpositiv = new StringBuffer("");
        this.secnegativ = new StringBuffer("");
        this.tb = new MainToolbox();
    }

    void ComputeIban() throws Exception {
        if (this.VFlag > 0 && this.VFlag < 10) {
            Pattern SNB;
            Matcher m_SNB;
            Pattern SNB2;
            Matcher m_SNB2;
            if (this.KoZE.length() > 13 && this.KoZE.substring(9, 13).intern() == "10AA" && this.bcrecord.AlgorithmusKtoPropr.equals("SVR1")) {
                this.KoZe_modifiziert = this.KoZe_modifiziert;
                this.Ban = this.KoZE.replace(9, 13, "0000");
                this.Ban = new StringBuffer(this.KoZE.substring(11, this.KoZE.length()));
            }
            StringBuffer vorpz = new StringBuffer(this.FillZeroLeft(new StringBuffer(String.valueOf(this.bcrecord.IID)), 5).toString());
            if (this.bcrecord.AlgorithmusKtoPropr.equals("SNB") && this.bcrecord.IID != 110 && (m_SNB2 = (SNB2 = Pattern.compile("^(15305|15323|15332)[.][0-9]{5}$")).matcher(this.KoZE)).matches()) {
                this.IID_BC = new StringBuffer("110");
                vorpz = new StringBuffer("110");
            }
            vorpz.append(this.FillZeroLeft(this.Ban, 12));
            vorpz.append(this.bcrecord.Landcode);
            vorpz.append("00");
            StringBuffer PZ = new StringBuffer(this.CalcModulo9710(vorpz).toString());
            vorpz = null;
            this.Iban = new StringBuffer(this.bcrecord.Landcode);
            if (PZ.length() == 1) {
                PZ.append("0");
                PZ.reverse();
            }
            this.Iban.append(PZ);
            this.Iban.append(this.FillZeroLeft(new StringBuffer(String.valueOf(this.bcrecord.IID)), 5).toString());
            if (this.bcrecord.AlgorithmusKtoPropr.equals("SNB") && this.bcrecord.IID != 110 && (m_SNB = (SNB = Pattern.compile("^(15305|15323|15332)[.][0-9]{5}$")).matcher(this.KoZE)).matches()) {
                this.Iban = new StringBuffer(this.Iban.substring(0, this.Iban.length() - 5));
                this.Iban.append("00110");
            }
            this.Iban.append(this.FillZeroLeft(this.Ban, 12));
            if (this.Iban.length() != 21) {
                this.VFlag = 23;
                this.KoZe_modifiziert = new StringBuffer("ueberpruefen!!!: IBAN ist nicht 21 lang");
            }
            if (this.bcrecord.IID != 83047) {
                if (!this.bcrecord.AlgorithmusKtoPropr.equals("CS") && !this.CalcSumme(this.Ban)) {
                    this.VFlag = 23;
                    this.KoZe_modifiziert = new StringBuffer("ueberpruefen!!! Summe Ban-Teil = 0");
                } else if (this.VFlag == 3 && this.Iban.toString().intern() != this.KoZE.toString().intern()) {
                    this.KoZe_modifiziert = new StringBuffer("ueberpruefen!!! Hat Flag 3 - sollte Flag 8?");
                } else if (this.VFlag == 8 && this.Iban.toString().intern() == this.KoZE.toString().intern()) {
                    this.VFlag = 3;
                    this.KoZe_modifiziert = new StringBuffer("ueberpruefen!!! Hatte Flag 8 - korrigiert auf Flag 3");
                }
            }
        }
        if (this.VFlag >= 10 || this.VFlag <= 0) {
            this.IID_BC = new StringBuffer("");
            this.IID_PC = new StringBuffer("");
            this.Iban = new StringBuffer("");
        }
    }

    private StringBuffer FillZeroLeft(StringBuffer str_in, int finallength) {
        if (str_in.length() >= 0) {
            for (int i = str_in.length(); i < finallength; ++i) {
                str_in.insert(0, "0");
            }
        }
        return str_in;
    }

    private StringBuffer CalcModulo9710(StringBuffer in) throws Exception {
        int nextlength;
        StringBuffer iban_numeric = new StringBuffer("");
        for (int i = 0; i < in.length(); ++i) {
            if (in.charAt(i) >= 'A' && in.charAt(i) <= 'Z') {
                iban_numeric.append(in.charAt(i) - 55);
                continue;
            }
            iban_numeric.append(in.charAt(i));
        }
        int dividend = Integer.parseInt(iban_numeric.substring(0, 9));
        int restwert = dividend % 97;
        for (int restlaenge = iban_numeric.length() - 9; restlaenge > 0; restlaenge -= nextlength) {
            nextlength = restwert < 10 ? (restlaenge < 8 ? restlaenge : 8) : (restlaenge < 7 ? restlaenge : 7);
            dividend = Integer.parseInt(String.valueOf(restwert) + iban_numeric.substring(iban_numeric.length() - restlaenge, iban_numeric.length() - restlaenge + nextlength));
            restwert = dividend % 97;
        }
        StringBuffer Result = new StringBuffer(String.valueOf(98 - restwert));
        if (this.bcrecord.AlgorithmusKtoPropr.equals("SVR1") && this.KoZe_modifiziert.length() > 1) {
            this.KoZE = this.KoZe_modifiziert;
        }
        return Result;
    }

    boolean CalcSumme(StringBuffer inpc) {
        boolean Result = false;
        int sum = 0;
        for (int i = 0; i < inpc.length(); ++i) {
            try {
                if (!this.tb.isNumber(new StringBuffer(String.valueOf(inpc.charAt(i))))) continue;
                sum += Integer.parseInt(String.valueOf(inpc.charAt(i)));
                continue;
            }
            catch (Exception e) {
                Result = true;
                break;
            }
        }
        if (sum > 0) {
            Result = true;
        }
        return Result;
    }
}

