/*
 * Decompiled with CFR 0.152.
 */
package ch.sic.ibantool;

import ch.sic.ibantool.MainIBANRecord;
import ch.sic.ibantool.MainReader;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class MainReaderASCII
extends MainReader {
    private String FileName;
    private int NumRecords;
    private StringBuffer stringRead;
    private FileReader fr;
    private BufferedReader br;
    private Pattern p_line;
    private Pattern p_SeqNr;
    private Matcher m_line;
    private Matcher m_SeqNr;
    private int LastRecordSeqNr = 0;

    MainReaderASCII() {
    }

    void open(String filename) throws IOException {
        this.FileName = filename;
        this.p_line = Pattern.compile("^[0-9]{6}[;]{1}[.[^;]]{0,35}[;]{1}[.[^;]]{0,12}[;]{1}[.[^;]]{0,34}[;]{0,1}$");
        this.p_SeqNr = Pattern.compile("^[0-9]{6}[;].{0,300}$");
        this.NumRecords = 0;
        FileReader frcount = new FileReader(this.FileName);
        BufferedReader brcount = new BufferedReader(frcount);
        String aLine = null;
        while ((aLine = brcount.readLine()) != null) {
            this.m_line = this.p_SeqNr.matcher(aLine);
            if (!this.m_line.matches()) continue;
            ++this.NumRecords;
        }
        this.fr = new FileReader(this.FileName);
        this.br = new BufferedReader(this.fr);
    }

    MainIBANRecord NextRecord() throws Exception {
        MainIBANRecord Result = new MainIBANRecord();
        this.stringRead = new StringBuffer(this.br.readLine());
        this.m_line = this.p_line.matcher(this.stringRead.toString());
        this.m_SeqNr = this.p_SeqNr.matcher(this.stringRead.toString());
        if (this.m_SeqNr.matches()) {
            if (this.m_line.matches()) {
                Result.SeqNr = new StringBuffer(this.ReadnextStringToken());
                Result.SeqNrInt = Integer.parseInt(Result.SeqNr.toString());
                if (Result.SeqNrInt - 1 == this.LastRecordSeqNr) {
                    this.LastRecordSeqNr = Result.SeqNrInt;
                    Result.IndKuRef = new StringBuffer(this.ReadnextStringToken());
                    Result.InBC = new StringBuffer(this.ReadnextStringToken());
                    Result.KoZE = new StringBuffer(this.ReadnextStringToken());
                } else {
                    Result.VFlag = 29;
                }
            } else {
                Result.SeqNr = new StringBuffer(this.ReadnextStringToken());
                Result.SeqNrInt = Integer.parseInt(Result.SeqNr.toString());
                Result.VFlag = 29;
                if (Result.SeqNrInt - 1 == this.LastRecordSeqNr) {
                    this.LastRecordSeqNr = Result.SeqNrInt;
                    Result.VFlag = 29;
                }
            }
        } else {
            Result = this.NextRecord();
        }
        return Result;
    }

    int Listsize() throws Exception {
        return this.NumRecords;
    }

    void close() throws Exception {
        this.br.close();
    }

    private String ReadnextStringToken() {
        int i = 0;
        for (i = 0; i < this.stringRead.length() && this.stringRead.charAt(i) != ';'; ++i) {
        }
        String Result = this.stringRead.substring(0, i).toUpperCase();
        this.stringRead.delete(0, i + 1);
        return Result;
    }

    private int ReadnextIntToken() {
        int Result = 0;
        StringBuffer tmp_result = new StringBuffer(this.ReadnextStringToken());
        if (tmp_result.length() > 0) {
            try {
                Result = Integer.parseInt(tmp_result.toString());
            }
            catch (NumberFormatException nfe) {
                Result = 0;
            }
        } else {
            Result = 0;
        }
        return Result;
    }

    private boolean ReadnextBooleanToken() {
        boolean Result = false;
        String tmp_Result = this.ReadnextStringToken().toString();
        Result = tmp_Result.equals("1");
        return Result;
    }
}

