/*
 * Decompiled with CFR 0.152.
 */
package ch.sic.ibantool;

import ch.sic.ibantool.MainIBANRecord;
import ch.sic.ibantool.MainWriter;
import ch.sic.ibantool.RecordTotal;
import java.io.BufferedWriter;
import java.io.FileWriter;

class MainWriterASCII
extends MainWriter {
    private String FileName;
    private int NumRecords;
    private StringBuffer stringRead;
    private int LastRecordSeqNr = 0;
    private BufferedWriter bw;
    private FileWriter fw;
    private boolean extendedmode = false;

    MainWriterASCII() {
    }

    void open(String filename) throws Exception {
        this.FileName = filename;
        this.fw = new FileWriter(this.FileName);
        this.bw = new BufferedWriter(this.fw);
    }

    void AddRecord(MainIBANRecord iban) throws Exception {
        StringBuffer tmp_VFlag;
        if (iban.IndKuRef == null) {
            iban.IndKuRef = new StringBuffer("");
        }
        if (iban.InBC == null) {
            iban.InBC = new StringBuffer("");
        }
        if (iban.KoZE == null) {
            iban.KoZE = new StringBuffer("");
        }
        if (iban.IID_BC == null) {
            iban.IID_BC = new StringBuffer("");
        }
        if (iban.IID_PC == null) {
            iban.IID_PC = new StringBuffer("");
        }
        if (iban.Iban == null) {
            iban.Iban = new StringBuffer("");
        }
        if (iban.bcrecord.Email == null) {
            iban.bcrecord.Email = new String("");
        }
        if ((tmp_VFlag = new StringBuffer(String.valueOf(iban.VFlag))).length() == 1) {
            tmp_VFlag.insert(0, "0");
        }
        StringBuffer LinetoWrite = new StringBuffer(iban.SeqNr.toString() + ";" + iban.IndKuRef.toString() + ";" + iban.InBC.toString() + ";" + iban.KoZE.toString() + ";" + tmp_VFlag.toString() + ";");
        LinetoWrite.append(iban.IID_BC.toString() + ";" + iban.IID_PC.toString() + ";" + iban.Iban.toString() + ";");
        LinetoWrite.append(iban.bcrecord.Email.toString() + ";");
        this.bw.write(LinetoWrite.toString());
        if (this.extendedmode) {
            this.bw.write(";" + String.valueOf(iban.Feld2Typ));
            this.bw.write(";" + String.valueOf(iban.Feld3Typ));
            this.bw.write(";" + String.valueOf(iban.KoZe_modifiziert));
        }
        this.bw.newLine();
    }

    void close() throws Exception {
        if (this.bw != null) {
            this.bw.close();
        }
    }

    void AddTotalRecord(RecordTotal totrec) throws Exception {
        if (totrec.SeqNummer == null) {
            totrec.SeqNummer = new StringBuffer("");
        }
        StringBuffer sbwrite = new StringBuffer(totrec.SeqNummer.toString() + ";" + String.valueOf(totrec.Flag01) + ";" + String.valueOf(totrec.Flag02) + ";" + String.valueOf(totrec.Flag03) + ";" + String.valueOf(totrec.Flag04) + ";" + String.valueOf(totrec.Flag05) + ";" + String.valueOf(totrec.Flag06) + ";" + String.valueOf(totrec.Flag07) + ";" + String.valueOf(totrec.Flag08) + ";" + String.valueOf(totrec.Flag09) + ";" + String.valueOf(totrec.Flag10) + ";" + String.valueOf(totrec.Flag11) + ";" + String.valueOf(totrec.Flag12) + ";" + String.valueOf(totrec.Flag13) + ";" + String.valueOf(totrec.Flag14) + ";" + String.valueOf(totrec.Flag15) + ";" + String.valueOf(totrec.Flag16) + ";" + String.valueOf(totrec.Flag17) + ";" + String.valueOf(totrec.Flag18) + ";" + String.valueOf(totrec.Flag19) + ";" + String.valueOf(totrec.Flag20) + ";" + String.valueOf(totrec.Flag21) + ";" + String.valueOf(totrec.Flag22) + ";" + String.valueOf(totrec.Flag23) + ";" + String.valueOf(totrec.Flag24) + ";" + String.valueOf(totrec.Flag25) + ";" + String.valueOf(totrec.Flag26) + ";" + String.valueOf(totrec.Flag27) + ";" + String.valueOf(totrec.Flag28) + ";" + String.valueOf(totrec.Flag29) + ";" + String.valueOf(totrec.TotalRecords));
        if (this.extendedmode) {
            int totalOK = totrec.Flag01 + totrec.Flag02 + totrec.Flag03 + totrec.Flag04 + totrec.Flag05 + totrec.Flag06 + totrec.Flag07 + totrec.Flag08 + totrec.Flag09;
            float percentageiban = 100 * totalOK / totrec.TotalRecords;
            sbwrite.append(" Percentage IBAN calculations: " + percentageiban + "%");
        }
        this.bw.write(sbwrite.toString());
        this.bw.newLine();
    }

    void SetExtended(boolean mode) {
        this.extendedmode = mode;
    }
}

