/*
 * Decompiled with CFR 0.152.
 */
package ch.sic.ibantool;

import ch.sic.ibantool.MainBANInterface;
import ch.sic.ibantool.MainIBANRecord;
import ch.sic.ibantool.MainToolbox;
import java.util.HashMap;
import java.util.regex.Pattern;

class SW_Phoenix
extends MainBANInterface {
    private MainToolbox tb = new MainToolbox();
    private HashMap currencyCodes = new HashMap();

    public SW_Phoenix() {
        this.currencyCodes.put("USD", "001");
        this.currencyCodes.put("JPY", "003");
        this.currencyCodes.put("GBP", "004");
        this.currencyCodes.put("CAD", "005");
        this.currencyCodes.put("CHF", "006");
        this.currencyCodes.put("AUD", "011");
        this.currencyCodes.put("DKK", "012");
        this.currencyCodes.put("HKD", "015");
        this.currencyCodes.put("NOK", "018");
        this.currencyCodes.put("NZD", "019");
        this.currencyCodes.put("SEK", "020");
        this.currencyCodes.put("SGD", "021");
        this.currencyCodes.put("ZAR", "028");
        this.currencyCodes.put("KWD", "029");
        this.currencyCodes.put("TTD", "030");
        this.currencyCodes.put("PHP", "031");
        this.currencyCodes.put("TWD", "032");
        this.currencyCodes.put("SAR", "033");
        this.currencyCodes.put("KRW", "034");
        this.currencyCodes.put("NGN", "035");
        this.currencyCodes.put("MYR", "036");
        this.currencyCodes.put("IDR", "037");
        this.currencyCodes.put("THB", "038");
        this.currencyCodes.put("LKR", "039");
        this.currencyCodes.put("BND", "040");
        this.currencyCodes.put("CNY", "041");
        this.currencyCodes.put("INR", "042");
        this.currencyCodes.put("IRR", "046");
        this.currencyCodes.put("MAD", "047");
        this.currencyCodes.put("HUF", "049");
        this.currencyCodes.put("EEK", "051");
        this.currencyCodes.put("MXN", "052");
        this.currencyCodes.put("TND", "054");
        this.currencyCodes.put("AED", "056");
        this.currencyCodes.put("XDR", "057");
        this.currencyCodes.put("XPF", "058");
        this.currencyCodes.put("JOD", "060");
        this.currencyCodes.put("SYP", "061");
        this.currencyCodes.put("CZK", "062");
        this.currencyCodes.put("EGP", "063");
        this.currencyCodes.put("DZD", "064");
        this.currencyCodes.put("IQD", "066");
        this.currencyCodes.put("GNF", "067");
        this.currencyCodes.put("ARS", "068");
        this.currencyCodes.put("OMR", "070");
        this.currencyCodes.put("CLP", "071");
        this.currencyCodes.put("ZAL", "072");
        this.currencyCodes.put("KES", "073");
        this.currencyCodes.put("ZWD", "074");
        this.currencyCodes.put("MUR", "075");
        this.currencyCodes.put("SCR", "076");
        this.currencyCodes.put("PKR", "077");
        this.currencyCodes.put("BWP", "078");
        this.currencyCodes.put("NAD", "079");
        this.currencyCodes.put("XPD", "080");
        this.currencyCodes.put("XPT", "081");
        this.currencyCodes.put("XIR", "084");
        this.currencyCodes.put("XAG", "085");
        this.currencyCodes.put("QAR", "087");
        this.currencyCodes.put("PLN", "089");
        this.currencyCodes.put("SKK", "090");
        this.currencyCodes.put("PFN", "091");
        this.currencyCodes.put("BRL", "092");
        this.currencyCodes.put("HRK", "093");
        this.currencyCodes.put("ROL", "094");
        this.currencyCodes.put("RUB", "095");
        this.currencyCodes.put("ILS", "096");
        this.currencyCodes.put("XOF", "097");
        this.currencyCodes.put("XAF", "098");
        this.currencyCodes.put("XAU", "099");
        this.currencyCodes.put("EUR", "100");
        this.currencyCodes.put("XAL", "101");
        this.currencyCodes.put("SVC", "105");
        this.currencyCodes.put("LVL", "106");
        this.currencyCodes.put("BHD", "107");
        this.currencyCodes.put("ETB", "108");
        this.currencyCodes.put("LBP", "110");
        this.currencyCodes.put("MWK", "111");
        this.currencyCodes.put("SIT", "112");
        this.currencyCodes.put("TZS", "113");
        this.currencyCodes.put("NIO", "114");
        this.currencyCodes.put("LTL", "115");
        this.currencyCodes.put("ISK", "117");
        this.currencyCodes.put("RON", "118");
        this.currencyCodes.put("TRY", "119");
        this.currencyCodes.put("PAB", "130");
        this.currencyCodes.put("KZT", "131");
        this.currencyCodes.put("VEF", "134");
        this.currencyCodes.put("SDG", "135");
        this.currencyCodes.put("VND", "136");
        this.currencyCodes.put("BGN", "137");
    }

    MainIBANRecord ComputeBAN(MainIBANRecord rec) throws Exception {
        StringBuffer tmpkoze = new StringBuffer(rec.KoZE.toString().toUpperCase());
        tmpkoze = this.tb.EliminateSpecialChar(tmpkoze);
        Pattern phoenix = Pattern.compile("^[0-9]{9}[a-zA-Z]{3}$");
        if (phoenix.matcher(tmpkoze).matches()) {
            String countryCode = tmpkoze.substring(9).toUpperCase();
            String rest = tmpkoze.substring(0, 9);
            if (!this.currencyCodes.containsKey(countryCode)) {
                rec.VFlag = 20;
                return rec;
            }
            StringBuffer ban = new StringBuffer(rest + this.currencyCodes.get(countryCode));
            if (this.testCheckDigit(ban)) {
                rec.Ban = ban;
                rec.VFlag = 1;
            } else {
                rec.VFlag = 22;
            }
            return rec;
        }
        rec.VFlag = 20;
        return rec;
    }

    public boolean testCheckDigit(StringBuffer ban) {
        String customerNumber = ban.substring(0, 6);
        int checkDigit = Integer.parseInt(ban.substring(6, 7));
        int calculatedCheckDigit = 0;
        int[] weights = new int[]{1, 2, 1, 2, 1, 2};
        for (int i = 0; i < customerNumber.length(); ++i) {
            int number = Character.getNumericValue(customerNumber.charAt(i)) * weights[i];
            calculatedCheckDigit += this.tb.calculcateCrossSum(number);
        }
        calculatedCheckDigit = calculatedCheckDigit % 10 != 0 ? calculatedCheckDigit + (10 - calculatedCheckDigit % 10) - calculatedCheckDigit : 0;
        return calculatedCheckDigit == checkDigit;
    }

    public HashMap getCurrencyCodes() {
        return this.currencyCodes;
    }
}

