/*
 * Decompiled with CFR 0.152.
 */
package ch.sic.ibantool;

import ch.sic.ibantool.Bank_GUERB;
import ch.sic.ibantool.Bank_JURA;
import ch.sic.ibantool.Bank_RBA;
import ch.sic.ibantool.MainBCRecord;
import ch.sic.ibantool.MainBCStamm;
import ch.sic.ibantool.MainIBANRecord;
import ch.sic.ibantool.MainToolbox;
import ch.sic.ibantool.SW_FINNOVA;
import ch.sic.ibantool.Spec_Iban_CS;
import ch.sic.ibantool.Spec_Iban_ESPRIT;
import ch.sic.ibantool.Spec_Iban_IBIS;
import ch.sic.ibantool.Spec_Iban_Phoenix;
import ch.sic.ibantool.Spec_Iban_TGKB;
import ch.sic.ibantool.Spec_Iban_UBS;
import ch.sic.ibantool.Spec_Iban_ZKB;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Spec_Iban {
    MainToolbox tb = new MainToolbox();
    MainBCStamm bcs;

    Spec_Iban(MainBCStamm bcs_in) {
        this.bcs = bcs_in;
    }

    MainIBANRecord ComputeIBAN(MainIBANRecord rec) throws Exception {
        rec.KoZE = this.tb.EliminateChar(' ', rec.KoZE);
        int PZ_Calc = this.CalcPZ_Iban(rec.KoZE);
        if (PZ_Calc == 1) {
            if (rec.bcrecord.AlgorithmusKtoPropr.intern() == "UBS".intern()) {
                Spec_Iban_UBS IBANUBS = new Spec_Iban_UBS(this.bcs);
                rec = IBANUBS.ComputeBAN(rec);
            } else if (rec.bcrecord.AlgorithmusKtoPropr.intern() == "ZKB".intern()) {
                Spec_Iban_ZKB IBANZKB = new Spec_Iban_ZKB(this.bcs);
                rec = IBANZKB.ComputeBAN(rec);
            } else if (rec.bcrecord.AlgorithmusKtoPropr.equals("SKWI") || rec.bcrecord.AlgorithmusKtoPropr.equals("CASG") || rec.bcrecord.AlgorithmusKtoPropr.equals("SRB") || rec.bcrecord.AlgorithmusKtoPropr.equals("ARB") || rec.bcrecord.AlgorithmusKtoPropr.equals("BZSD") || rec.bcrecord.AlgorithmusKtoPropr.equals("ABS") || rec.bcrecord.AlgorithmusKtoPropr.equals("EKII") || rec.bcrecord.AlgorithmusKtoPropr.equals("EEK") || rec.bcrecord.AlgorithmusKtoPropr.equals("SLBU") || rec.bcrecord.AlgorithmusKtoPropr.equals("AXA") || rec.bcrecord.AlgorithmusKtoPropr.equals("AEKS") || rec.bcrecord.AlgorithmusKtoPropr.equals("EKRU") || rec.bcrecord.AlgorithmusKtoPropr.equals("BBOB") || rec.bcrecord.AlgorithmusKtoPropr.equals("AEKT") || rec.bcrecord.AlgorithmusKtoPropr.equals("BKTH") || rec.bcrecord.AlgorithmusKtoPropr.equals("SLFF") || rec.bcrecord.AlgorithmusKtoPropr.equals("RSOS")) {
                Spec_Iban_ESPRIT IBANESPRIT = new Spec_Iban_ESPRIT(this.bcs);
                rec = IBANESPRIT.ComputeBAN(rec);
            } else if (rec.bcrecord.AlgorithmusESCod == 24 || rec.bcrecord.AlgorithmusKtoPropr.equals("JURA")) {
                StringBuffer origkoze;
                Spec_Iban_IBIS IBANIBIS = new Spec_Iban_IBIS(this.bcs);
                rec = IBANIBIS.ComputeBAN(rec);
                if (rec.VFlag > 19 && rec.bcrecord.BCNummer == 6830) {
                    origkoze = new StringBuffer(rec.KoZE.toString());
                    rec.KoZE = new StringBuffer(rec.KoZE.substring(9, 21));
                    Bank_RBA bank_lien = new Bank_RBA();
                    rec = bank_lien.ComputeBAN(rec);
                    if (rec.VFlag == 2) {
                        rec.VFlag = 3;
                        rec.KoZe_modifiziert = new StringBuffer("");
                    }
                    rec.KoZE = origkoze;
                } else if (rec.VFlag > 19 && (rec.bcrecord.AlgorithmusKtoPropr.equals("RBA") || rec.bcrecord.AlgorithmusKtoPropr.equals("VBBE"))) {
                    origkoze = new StringBuffer(rec.KoZE.toString());
                    rec.KoZE = new StringBuffer(rec.KoZE.substring(9, 21));
                    SW_FINNOVA sw_finnova = new SW_FINNOVA();
                    rec = sw_finnova.ComputeBAN(rec);
                    if (rec.VFlag > 19 && rec.KoZE.length() > 9) {
                        rec.VFlag = -1;
                        StringBuffer tmpkoze = new StringBuffer(rec.KoZE.substring(2, 12));
                        Pattern Ent = Pattern.compile("^99[0-9]{8}$");
                        Matcher a_Ent = Ent.matcher(tmpkoze);
                        if (a_Ent.matches()) {
                            rec.Ban = new StringBuffer(tmpkoze);
                            rec.VFlag = 3;
                            rec.KoZe_modifiziert = new StringBuffer("");
                        } else {
                            rec.VFlag = 21;
                        }
                    }
                    if (rec.VFlag == 1) {
                        rec.VFlag = 3;
                    }
                    rec.KoZE = origkoze;
                } else if (rec.VFlag > 19 && rec.bcrecord.AlgorithmusKtoPropr.equals("JURA")) {
                    origkoze = new StringBuffer(rec.KoZE.toString());
                    rec.KoZE = new StringBuffer(rec.KoZE.substring(9, 21));
                    Bank_JURA bank_jura = new Bank_JURA();
                    rec = bank_jura.ComputeBAN(rec);
                    if (rec.VFlag == 1) {
                        rec.VFlag = 3;
                    }
                    rec.KoZE = origkoze;
                } else if (rec.VFlag > 19 && rec.bcrecord.AlgorithmusKtoPropr.equals("GUERB")) {
                    origkoze = new StringBuffer(rec.KoZE.toString());
                    rec.KoZE = new StringBuffer(rec.KoZE.substring(10, 21));
                    Bank_GUERB bank_guerb = new Bank_GUERB();
                    rec = bank_guerb.ComputeBAN(rec);
                    if (rec.VFlag == 2) {
                        rec.VFlag = 3;
                        rec.KoZe_modifiziert = new StringBuffer("");
                    }
                    rec.KoZE = origkoze;
                }
            } else if (rec.bcrecord.AlgorithmusKtoPropr.intern() == "TGKB".intern()) {
                Spec_Iban_TGKB IBANTGKB = new Spec_Iban_TGKB(this.bcs);
                rec = IBANTGKB.ComputeBAN(rec);
            } else if (rec.bcrecord.AlgorithmusKtoPropr.equals("GEKB")) {
                StringBuffer newIBAN;
                String x = rec.KoZE.substring(9, 12);
                if (!x.equals("000")) {
                    rec.VFlag = 8;
                }
                rec.Ban = newIBAN = new StringBuffer(rec.KoZE.substring(rec.KoZE.length() - 9, rec.KoZE.length()));
            } else if (rec.bcrecord.AlgorithmusKtoPropr.equals("COBA")) {
                Spec_Iban_Phoenix spec_iban = new Spec_Iban_Phoenix(this.bcs);
                rec = spec_iban.ComputeBAN(rec);
            }
            if (rec.VFlag < 10) {
                StringBuffer bc = new StringBuffer(rec.KoZE.substring(4, 9));
                int bcint = Integer.parseInt(bc.toString());
                if (rec.Ban.length() == 0) {
                    rec.Ban = new StringBuffer(rec.KoZE.substring(9, 21));
                }
                bc = this.tb.EliminateLeadingZero(bc);
                StringBuffer bcStamm = new StringBuffer(rec.IID_BC.toString());
                if (bc.toString().equals(bcStamm.toString())) {
                    if (rec.VFlag < 0) {
                        rec.VFlag = Integer.parseInt(bc.toString()) == bcint ? 3 : 8;
                    }
                } else if (rec.bcrecord.AlgorithmusKtoPropr.intern() == "CS".intern()) {
                    Spec_Iban_CS IBANCS = new Spec_Iban_CS(this.bcs);
                    rec = IBANCS.ComputeBAN(rec);
                } else if (rec.VFlag == -1) {
                    MainBCRecord bcr = new MainBCRecord();
                    bcr = this.bcs.GetBCRecordbyBCNumber(bcint);
                    if (bcr.SortierNr != -1) {
                        rec.VFlag = rec.bcrecord.AlgorithmusKtoPropr.equals(bcr.AlgorithmusKtoPropr) ? (rec.bcrecord.AlgorithmusKtoPropr.equals("SVR1") || bcr.AlgorithmusKtoPropr.equals("SVR2") ? 3 : 8) : (rec.bcrecord.AlgorithmusKtoPropr.equals("SVR1") && bcr.AlgorithmusKtoPropr.equals("SVR2") || rec.bcrecord.AlgorithmusKtoPropr.equals("SVR2") && bcr.AlgorithmusKtoPropr.equals("SVR1") ? 3 : 27);
                        if (rec.bcrecord.AlgorithmusKtoPropr.equals("SVR2") && rec.VFlag < 10) {
                            StringBuffer svrban = new StringBuffer(rec.KoZE);
                            svrban = new StringBuffer(svrban.substring(svrban.length() - 12, svrban.length()));
                            rec.VFlag = (svrban = this.tb.EliminateLeadingZero(svrban)).length() <= rec.bcrecord.KtoNrMax && svrban.length() >= rec.bcrecord.KtoNrMin ? 3 : 23;
                        }
                        rec.bcrecord = bcr;
                        if (rec.VFlag < 10) {
                            if (rec.bcrecord.AlgorithmusKtoPropr.equals("DEUT")) {
                                rec.IID_BC = new StringBuffer("87801");
                                if (Integer.parseInt(rec.IID_BC.toString()) == bcint) {
                                    rec.VFlag = 3;
                                }
                            } else {
                                rec.IID_BC = new StringBuffer(String.valueOf(rec.bcrecord.IID));
                            }
                        }
                    } else {
                        rec.VFlag = 27;
                    }
                } else {
                    rec.VFlag = 8;
                }
            }
        } else {
            rec.VFlag = 26;
        }
        return rec;
    }

    private int CalcPZ_Iban(StringBuffer in) throws Exception {
        int nextlength;
        StringBuffer tmp_sb;
        in = tmp_sb = new StringBuffer(in.substring(4, 21).concat(in.substring(0, 4)));
        StringBuffer iban_numeric = new StringBuffer("");
        for (int i = 0; i < in.length(); ++i) {
            if (in.charAt(i) >= 'A' && in.charAt(i) <= 'Z') {
                iban_numeric.append(in.charAt(i) - 55);
                continue;
            }
            iban_numeric.append(in.charAt(i));
        }
        iban_numeric = this.tb.EliminateChar(' ', iban_numeric);
        int dividend = Integer.parseInt(iban_numeric.substring(0, 9));
        int restwert = dividend % 97;
        for (int restlaenge = iban_numeric.length() - 9; restlaenge > 0; restlaenge -= nextlength) {
            nextlength = restwert < 10 ? (restlaenge < 8 ? restlaenge : 8) : (restlaenge < 7 ? restlaenge : 7);
            dividend = Integer.parseInt(String.valueOf(restwert) + iban_numeric.substring(iban_numeric.length() - restlaenge, iban_numeric.length() - restlaenge + nextlength));
            restwert = dividend % 97;
        }
        return restwert;
    }
}

